; Script generated with the Venis Install Wizard

; Define your application name
!define APPNAME "Renegade BBS"
!define APPNAMEANDVERSION "Renegade BBS 01-10.4"

; Main Install settings
Name "${APPNAMEANDVERSION}"
InstallDir "C:\RG\"
InstallDirRegKey HKLM "Software\${APPNAME}" ""
OutFile "..\..\..\Program Files\Venis\rgxsetup.exe"

; Modern interface settings
!include "MUI.nsh"

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN "$INSTDIR\RG.BAT L"
!define MUI_ICON "..\..\..\bluewolficon.ico"
!define MUI_UNICON "..\..\..\bluewolficon.ico"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "..\..\..\RG2\DOCS\LICENSE.TXT"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_RESERVEFILE_LANGDLL

Section "Renegade BBS" Section1

	; Set Section properties
	SectionIn RO
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "..\..\..\RG2\LOGON.BAT"
	File "..\..\..\RG2\RENEGADE.EXE"
	File "..\..\..\RG2\RENEGADE.OVR"
	File "..\..\..\RG2\RENEMAIL.EXE"
	File "..\..\..\RG2\RENEGADE.DAT"
	File "..\..\..\RG2\RUP.EXE"
	File "..\..\..\RG2\RG.BAT"
	File "..\..\..\RG2\1stboot"
	SetOutPath "$INSTDIR\ARCS\"
	File "..\..\..\RG2\ARCS\PKUNZIP.EXE"
	File "..\..\..\RG2\ARCS\PKZIP.EXE"
	SetOutPath "$INSTDIR\DATA\"
	File "..\..\..\RG2\DATA\BBSLIST.TPL"
	File "..\..\..\RG2\DATA\CONFRENC.DAT"
	File "..\..\..\RG2\DATA\EVENTS.DAT"
	File "..\..\..\RG2\DATA\MBASES.DAT"
	File "..\..\..\RG2\DATA\NODE1.DAT"
	File "..\..\..\RG2\DATA\PROTOCOL.DAT"
	File "..\..\..\RG2\DATA\SCHEME.DAT"
	File "..\..\..\RG2\DATA\STRING.DAT"
	File "..\..\..\RG2\DATA\VOTING.DAT"
	File "..\..\..\RG2\DATA\HISTORY.DAT"
	File "..\..\..\RG2\DATA\USERS.DAT"
	File "..\..\..\RG2\DATA\TOGGLES.DAT"
	SetOutPath "$INSTDIR\MENU\"
	File "..\..\..\RG2\MENU\CENTRAL.MNU"
	File "..\..\..\RG2\MENU\ENTRTAIN.MNU"
	File "..\..\..\RG2\MENU\FDIR.MNU"
	File "..\..\..\RG2\MENU\FILE.MNU"
	File "..\..\..\RG2\MENU\FILEOP.MNU"
	File "..\..\..\RG2\MENU\FILEP.MNU"
	File "..\..\..\RG2\MENU\FSEARCH.MNU"
	File "..\..\..\RG2\MENU\GLOBAL.MNU"
	File "..\..\..\RG2\MENU\INFO.MNU"
	File "..\..\..\RG2\MENU\MESSAGE.MNU"
	File "..\..\..\RG2\MENU\MSGOP.MNU"
	File "..\..\..\RG2\MENU\NEWINFO.MNU"
	File "..\..\..\RG2\MENU\READP.MNU"
	File "..\..\..\RG2\MENU\SETUP.MNU"
	File "..\..\..\RG2\MENU\START.MNU"
	File "..\..\..\RG2\MENU\SYSOP.MNU"
	File "..\..\..\RG2\MENU\TEMPLATE.MNU"
	File "..\..\..\RG2\MENU\TIMEBANK.MNU"
	File "..\..\..\RG2\MENU\UTILITY.MNU"
	File "..\..\..\RG2\MENU\VOTING.MNU"
	SetOutPath "$INSTDIR\MISC\"
	File "..\..\..\RG2\MISC\BATCHUL0.ASC"
	File "..\..\..\RG2\MISC\BBSEH.ASC"
	File "..\..\..\RG2\MISC\BBSET.ASC"
	File "..\..\..\RG2\MISC\BBSME.ASC"
	File "..\..\..\RG2\MISC\BBSMN.ASC"
	File "..\..\..\RG2\MISC\BBSNH.ASC"
	File "..\..\..\RG2\MISC\BBSNT.ASC"
	File "..\..\..\RG2\MISC\BULLETIN.ASC"
	File "..\..\..\RG2\MISC\CENTR.ANS"
	File "..\..\..\RG2\MISC\COLOR.ASC"
	File "..\..\..\RG2\MISC\ENTR.ANS"
	File "..\..\..\RG2\MISC\FILE.ANS"
	File "..\..\..\RG2\MISC\FILEOP.ANS"
	File "..\..\..\RG2\MISC\FSHELP.ASC"
	File "..\..\..\RG2\MISC\INTRNODE.ANS"
	File "..\..\..\RG2\MISC\INTRNODE.ASC"
	File "..\..\..\RG2\MISC\LASTH.ASC"
	File "..\..\..\RG2\MISC\LASTM.ASC"
	File "..\..\..\RG2\MISC\LASTT.ASC"
	File "..\..\..\RG2\MISC\LOGOFF.ASC"
	File "..\..\..\RG2\MISC\MENUCMD.ASC"
	File "..\..\..\RG2\MISC\MSG.ANS"
	File "..\..\..\RG2\MISC\MSGOP.ANS"
	File "..\..\..\RG2\MISC\NEWINFO.ANS"
	File "..\..\..\RG2\MISC\NEWINFO.ASC"
	File "..\..\..\RG2\MISC\NODELH.ASC"
	File "..\..\..\RG2\MISC\NODELM.ASC"
	File "..\..\..\RG2\MISC\NODELT.ASC"
	File "..\..\..\RG2\MISC\PRELOGON.ASC"
	File "..\..\..\RG2\MISC\PRHELP.ASC"
	File "..\..\..\RG2\MISC\PSEUDOS.ASC"
	File "..\..\..\RG2\MISC\SETUP.ANS"
	File "..\..\..\RG2\MISC\SETUP.ASC"
	File "..\..\..\RG2\MISC\SYSTEM.ASC"
	File "..\..\..\RG2\MISC\TELEHELP.ANS"
	File "..\..\..\RG2\MISC\TELEHELP.ASC"
	File "..\..\..\RG2\MISC\TIMEDOUT.ASC"
	File "..\..\..\RG2\MISC\USERH.ASC"
	File "..\..\..\RG2\MISC\USERM.ASC"
	File "..\..\..\RG2\MISC\USERT.ASC"
	File "..\..\..\RG2\MISC\UTIL.ANS"
	File "..\..\..\RG2\MISC\VOTE.ANS"
	File "..\..\..\RG2\MISC\YOURINFO.ASC"
	File "..\..\..\RG2\MISC\DOSHELP.ASC"
	File "..\..\..\RG2\MISC\ACTIONS.ASC"
	File "..\..\..\RG2\MISC\ACTIONS.LST"
	File "..\..\..\RG2\MISC\PROTSUL.ASC"
	File "..\..\..\RG2\MISC\PROTBUL.ASC"
	File "..\..\..\RG2\MISC\PROTRES.ASC"
	File "..\..\..\RG2\MISC\PROTBDL.ASC"
	File "..\..\..\RG2\MISC\PROTSDL.ASC"
	SetOutPath "$INSTDIR\MSGS\"
	File "..\..\..\RG2\MSGS\EMAIL.HDR"
	SetOutPath "$INSTDIR\PROT\"
	File "..\..\..\RG2\PROT\CEXYZ.EXE"
	File "..\..\..\RG2\PROT\fdsz.exe"
	File "..\..\..\RG2\PROT\synzm10.zip"
	SetOutPath "$INSTDIR\DOCS\"
	File "..\..\..\RG2\DOCS\LICENSE.TXT"
	File "..\..\..\RG2\DOCS\MCI.DOC"
	File "..\..\..\RG2\DOCS\RGD12303.DOC"
	File "..\..\..\RG2\DOCS\WHATDONE"
	File "..\..\..\RG2\DOCS\RENEMAIL.DOC"
	File "..\..\..\RG2\DOCS\QUICKREF.PDF"
	File "..\..\..\RG2\DOCS\RENDOCS.PDF"
	File "..\..\..\RG2\DOCS\whatdone.txt"
	File "..\..\..\RG2\DOCS\todo.txt"
  CreateDirectory "$INSTDIR\FATTACH"
  CreateDirectory "$INSTDIR\LOGS"
  CreateShortCut "$DESKTOP\Renegade BBS.lnk" "$INSTDIR\RG.BAT L"
	CreateDirectory "$SMPROGRAMS\Renegade BBS 01-10.4"
	CreateShortCut "$SMPROGRAMS\Renegade BBS 01-10.4\Renegade BBS.lnk" "$INSTDIR\RG.BAT L"
	CreateShortCut "$SMPROGRAMS\Renegade BBS 01-10.4\Uninstall.lnk" "$INSTDIR\uninstall.exe"
SectionEnd

Section "Action" Section2

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\UTILS\ACTION\"
	File "..\..\..\RG2\UTILS\ACTION\ACTION.EXE"
	File "..\..\..\RG2\UTILS\ACTION\ACTIONS.LST"
	File "..\..\..\RG2\UTILS\ACTION\ACTIONS.ASC"
	File "..\..\..\RG2\UTILS\ACTION\ACTIONS.ANS"
	File "..\..\..\RG2\UTILS\ACTION\README.TXT"
	File "..\..\..\RG2\UTILS\ACTION\ACTIONS.BAK"

SectionEnd

Section "Usenet Ad Postter" Section3

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\UTILS\ADPOST\"
	File "..\..\..\RG2\UTILS\ADPOST\ad1.txt"
	File "..\..\..\RG2\UTILS\ADPOST\ad.exe"
	File "..\..\..\RG2\UTILS\ADPOST\ad2.txt"
	File "..\..\..\RG2\UTILS\ADPOST\file_id.diz"
	File "..\..\..\RG2\UTILS\ADPOST\msg-id.dat"
	File "..\..\..\RG2\UTILS\ADPOST\ad.ini"

SectionEnd

Section "Ansi2Gif / Ansi2 ___" Section4

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\UTILS\ANSI2GIF\"
	File "..\..\..\RG2\UTILS\ANSI2GIF\pvw32con.exe"
	File "..\..\..\RG2\UTILS\ANSI2GIF\pngans.exe"
	File "..\..\..\RG2\UTILS\ANSI2GIF\convert.bat"
	File "..\..\..\RG2\UTILS\ANSI2GIF\TODO.ANS"
	File "..\..\..\RG2\UTILS\ANSI2GIF\FAQ.ANS"
	File "..\..\..\RG2\UTILS\ANSI2GIF\todo.bmp"
	File "..\..\..\RG2\UTILS\ANSI2GIF\faq.bmp"

SectionEnd

Section "GameSrv" Section5

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\UTILS\GAMESRV\"
	File "..\..\..\RG2\UTILS\GAMESRV\GameSrv.exe"
	File "..\..\..\RG2\UTILS\GAMESRV\NF.BAT"
	File "..\..\..\RG2\UTILS\GAMESRV\SETUP.INI"
	File "..\..\..\RG2\UTILS\GAMESRV\Shortcut to GameSrv.exe.lnk"
	SetOutPath "$INSTDIR\UTILS\GAMESRV\Doc\"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\gamesrv-1.png"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\gamesrv-2.png"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\gamesrv-3.png"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\gamesrv-4.png"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\gamesrv-5.png"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\gamesrv-6.png"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\gamesrv-7.png"
	File "..\..\..\RG2\UTILS\GAMESRV\Doc\GameSrv.html"
	SetOutPath "$INSTDIR\UTILS\GAMESRV\mSyncFos\"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\dosxtrn.exe"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\DOSXTRN.PIF"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\mSyncFos.cfg"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\mSyncFos.dof"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\mSyncFos.dpr"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\mSyncFos.exe"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\sbbsexec.dll"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\sbbsexec.vxd"
	SetOutPath "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\DOSXTRN.EXE"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\FILE_ID.DIZ"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\gpl.txt"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\READ.ME"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\sbbsexec.dll"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\syncfos.exe"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\syncfos.foscfg"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\SYNCFOS.PAS"
	File "..\..\..\RG2\UTILS\GAMESRV\mSyncFos\FOS_202\SYNCFOS.TXT"

SectionEnd

Section "Multi-Server" Section6

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\UTILS\MSERV\"
	File "..\..\..\RG2\UTILS\MSERV\alias.cfg"
	File "..\..\..\RG2\UTILS\MSERV\file_id.diz"
	File "..\..\..\RG2\UTILS\MSERV\in.bat"
	File "..\..\..\RG2\UTILS\MSERV\in.cmd"
	File "..\..\..\RG2\UTILS\MSERV\mserve2.exe"
	File "..\..\..\RG2\UTILS\MSERV\mserve32.exe"
	File "..\..\..\RG2\UTILS\MSERV\restrict.cfg"
	File "..\..\..\RG2\UTILS\MSERV\route.cfg"
	File "..\..\..\RG2\UTILS\MSERV\servers.cfg"
	File "..\..\..\RG2\UTILS\MSERV\servers.doc"
	File "..\..\..\RG2\UTILS\MSERV\howto.tut"

SectionEnd

Section "mtype" Section7

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\UTILS\MTYPE\"
	File "..\..\..\RG2\UTILS\MTYPE\MTYPE.EXE"
	File "..\..\..\RG2\UTILS\MTYPE\MTYPE.DOC"
	File "..\..\..\RG2\UTILS\MTYPE\FILE_ID.DIZ"
	File "..\..\..\RG2\UTILS\MTYPE\T.BAT"

SectionEnd

Section "Pipe Draw" Section8

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\UTILS\"
	File "..\..\..\RG2\UTILS\PDRAW\PIPEDRAW.DOC"
	File "..\..\..\RG2\UTILS\PDRAW\PIPEDRAW.IN~"
	File "..\..\..\RG2\UTILS\PDRAW\DEFAULT.MCI"
	File "..\..\..\RG2\UTILS\PDRAW\BBSLIST.MCI"
	File "..\..\..\RG2\UTILS\PDRAW\USERLIST.MCI"
	File "..\..\..\RG2\UTILS\PDRAW\LASTCALL.MCI"
	File "..\..\..\RG2\UTILS\PDRAW\NODELIST.MCI"
	File "..\..\..\RG2\UTILS\PDRAW\FILE_ID.DIZ"
	File "..\..\..\RG2\UTILS\PDRAW\PIPEDRAW.EXE"
	File "..\..\..\RG2\UTILS\PDRAW\P.BAT"
	File "..\..\..\RG2\UTILS\PDRAW\PIPEDRAW.INI"

SectionEnd

Section -FinishSection

	WriteRegStr HKLM "Software\${APPNAME}" "" "$INSTDIR"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName" "${APPNAME}"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" "$INSTDIR\uninstall.exe"
	WriteUninstaller "$INSTDIR\uninstall.exe"

SectionEnd

; Modern install component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
	!insertmacro MUI_DESCRIPTION_TEXT ${Section1} "Renegade Bulletin Board Base Install"
	!insertmacro MUI_DESCRIPTION_TEXT ${Section2} "Action is an editor for the Renegade Teleconferance Actions.lst"
	!insertmacro MUI_DESCRIPTION_TEXT ${Section3} "Adposter will post predefined text messages on usenet.  Good for postting ads for you bbs."
	!insertmacro MUI_DESCRIPTION_TEXT ${Section4} "Ansi 2 Gif will convert an Ansi to a gif file for display on a webpage or any other thing you can think of."
	!insertmacro MUI_DESCRIPTION_TEXT ${Section5} "GameSrv:  You will be able to run your board via Telnet with GameSrv."
	!insertmacro MUI_DESCRIPTION_TEXT ${Section6} "Multi-Server will Allow you to recieve and send email with your BBS."
	!insertmacro MUI_DESCRIPTION_TEXT ${Section7} "MType: Set this up in your Path and you will be able to view ansi pipe and ansi.  Replacement for the Ansi.sys that don't work on later systems."
	!insertmacro MUI_DESCRIPTION_TEXT ${Section8} "PDraw:  This is a light wieght Ansi/Pipe editor that is freeware that will allow you to edit .asc files for renegade."
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Uninstall section
Section Uninstall

	;Remove from registry...
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"
	DeleteRegKey HKLM "SOFTWARE\${APPNAME}"

	; Delete self
	Delete "$INSTDIR\uninstall.exe"

	; Delete Shortcuts
	Delete "$DESKTOP\Renegade BBS.lnk"
	Delete "$SMPROGRAMS\Renegade BBS 01-10.4\Renegade BBS.lnk"
	Delete "$SMPROGRAMS\Renegade BBS 01-10.4\Uninstall.lnk"

	; Clean up Renegade BBS
	Delete "$INSTDIR\LOGON.BAT"
	Delete "$INSTDIR\RENEGADE.EXE"
	Delete "$INSTDIR\RENEGADE.OVR"
	Delete "$INSTDIR\RENEMAIL.EXE"
	Delete "$INSTDIR\RENEGADE.DAT"
	Delete "$INSTDIR\RUP.EXE"
	Delete "$INSTDIR\RG.BAT"
	Delete "$INSTDIR\1stboot"
	Delete "$INSTDIR\ARCS\PKUNZIP.EXE"
	Delete "$INSTDIR\ARCS\PKZIP.EXE"
	Delete "$INSTDIR\DATA\BBSLIST.TPL"
	Delete "$INSTDIR\DATA\CONFRENC.DAT"
	Delete "$INSTDIR\DATA\EVENTS.DAT"
	Delete "$INSTDIR\DATA\MBASES.DAT"
	Delete "$INSTDIR\DATA\NODE1.DAT"
	Delete "$INSTDIR\DATA\PROTOCOL.DAT"
	Delete "$INSTDIR\DATA\SCHEME.DAT"
	Delete "$INSTDIR\DATA\STRING.DAT"
	Delete "$INSTDIR\DATA\VOTING.DAT"
	Delete "$INSTDIR\DATA\HISTORY.DAT"
	Delete "$INSTDIR\DATA\USERS.DAT"
	Delete "$INSTDIR\DATA\TOGGLES.DAT"
	Delete "$INSTDIR\MENU\CENTRAL.MNU"
	Delete "$INSTDIR\MENU\ENTRTAIN.MNU"
	Delete "$INSTDIR\MENU\FDIR.MNU"
	Delete "$INSTDIR\MENU\FILE.MNU"
	Delete "$INSTDIR\MENU\FILEOP.MNU"
	Delete "$INSTDIR\MENU\FILEP.MNU"
	Delete "$INSTDIR\MENU\FSEARCH.MNU"
	Delete "$INSTDIR\MENU\GLOBAL.MNU"
	Delete "$INSTDIR\MENU\INFO.MNU"
	Delete "$INSTDIR\MENU\MESSAGE.MNU"
	Delete "$INSTDIR\MENU\MSGOP.MNU"
	Delete "$INSTDIR\MENU\NEWINFO.MNU"
	Delete "$INSTDIR\MENU\READP.MNU"
	Delete "$INSTDIR\MENU\SETUP.MNU"
	Delete "$INSTDIR\MENU\START.MNU"
	Delete "$INSTDIR\MENU\SYSOP.MNU"
	Delete "$INSTDIR\MENU\TEMPLATE.MNU"
	Delete "$INSTDIR\MENU\TIMEBANK.MNU"
	Delete "$INSTDIR\MENU\UTILITY.MNU"
	Delete "$INSTDIR\MENU\VOTING.MNU"
	Delete "$INSTDIR\MISC\BATCHUL0.ASC"
	Delete "$INSTDIR\MISC\BBSEH.ASC"
	Delete "$INSTDIR\MISC\BBSET.ASC"
	Delete "$INSTDIR\MISC\BBSME.ASC"
	Delete "$INSTDIR\MISC\BBSMN.ASC"
	Delete "$INSTDIR\MISC\BBSNH.ASC"
	Delete "$INSTDIR\MISC\BBSNT.ASC"
	Delete "$INSTDIR\MISC\BULLETIN.ASC"
	Delete "$INSTDIR\MISC\CENTR.ANS"
	Delete "$INSTDIR\MISC\COLOR.ASC"
	Delete "$INSTDIR\MISC\ENTR.ANS"
	Delete "$INSTDIR\MISC\FILE.ANS"
	Delete "$INSTDIR\MISC\FILEOP.ANS"
	Delete "$INSTDIR\MISC\FSHELP.ASC"
	Delete "$INSTDIR\MISC\INTRNODE.ANS"
	Delete "$INSTDIR\MISC\INTRNODE.ASC"
	Delete "$INSTDIR\MISC\LASTH.ASC"
	Delete "$INSTDIR\MISC\LASTM.ASC"
	Delete "$INSTDIR\MISC\LASTT.ASC"
	Delete "$INSTDIR\MISC\LOGOFF.ASC"
	Delete "$INSTDIR\MISC\MENUCMD.ASC"
	Delete "$INSTDIR\MISC\MSG.ANS"
	Delete "$INSTDIR\MISC\MSGOP.ANS"
	Delete "$INSTDIR\MISC\NEWINFO.ANS"
	Delete "$INSTDIR\MISC\NEWINFO.ASC"
	Delete "$INSTDIR\MISC\NODELH.ASC"
	Delete "$INSTDIR\MISC\NODELM.ASC"
	Delete "$INSTDIR\MISC\NODELT.ASC"
	Delete "$INSTDIR\MISC\PRELOGON.ASC"
	Delete "$INSTDIR\MISC\PRHELP.ASC"
	Delete "$INSTDIR\MISC\PSEUDOS.ASC"
	Delete "$INSTDIR\MISC\SETUP.ANS"
	Delete "$INSTDIR\MISC\SETUP.ASC"
	Delete "$INSTDIR\MISC\SYSTEM.ASC"
	Delete "$INSTDIR\MISC\TELEHELP.ANS"
	Delete "$INSTDIR\MISC\TELEHELP.ASC"
	Delete "$INSTDIR\MISC\TIMEDOUT.ASC"
	Delete "$INSTDIR\MISC\USERH.ASC"
	Delete "$INSTDIR\MISC\USERM.ASC"
	Delete "$INSTDIR\MISC\USERT.ASC"
	Delete "$INSTDIR\MISC\UTIL.ANS"
	Delete "$INSTDIR\MISC\VOTE.ANS"
	Delete "$INSTDIR\MISC\YOURINFO.ASC"
	Delete "$INSTDIR\MISC\DOSHELP.ASC"
	Delete "$INSTDIR\MISC\ACTIONS.ASC"
	Delete "$INSTDIR\MISC\ACTIONS.LST"
	Delete "$INSTDIR\MISC\PROTSUL.ASC"
	Delete "$INSTDIR\MISC\PROTBUL.ASC"
	Delete "$INSTDIR\MISC\PROTRES.ASC"
	Delete "$INSTDIR\MISC\PROTBDL.ASC"
	Delete "$INSTDIR\MISC\PROTSDL.ASC"
	Delete "$INSTDIR\MSGS\EMAIL.HDR"
	Delete "$INSTDIR\PROT\CEXYZ.EXE"
	Delete "$INSTDIR\PROT\fdsz.exe"
	Delete "$INSTDIR\PROT\synzm10.zip"
	Delete "$INSTDIR\DOCS\LICENSE.TXT"
	Delete "$INSTDIR\DOCS\MCI.DOC"
	Delete "$INSTDIR\DOCS\RGD12303.DOC"
	Delete "$INSTDIR\DOCS\WHATDONE"
	Delete "$INSTDIR\DOCS\RENEMAIL.DOC"
	Delete "$INSTDIR\DOCS\QUICKREF.PDF"
	Delete "$INSTDIR\DOCS\RENDOCS.PDF"
	Delete "$INSTDIR\DOCS\whatdone.txt"
	Delete "$INSTDIR\DOCS\todo.txt"

	; Clean up Action
	Delete "$INSTDIR\UTILS\ACTION\ACTION.EXE"
	Delete "$INSTDIR\UTILS\ACTION\ACTIONS.LST"
	Delete "$INSTDIR\UTILS\ACTION\ACTIONS.ASC"
	Delete "$INSTDIR\UTILS\ACTION\ACTIONS.ANS"
	Delete "$INSTDIR\UTILS\ACTION\README.TXT"
	Delete "$INSTDIR\UTILS\ACTION\ACTIONS.BAK"

	; Clean up Usenet Ad Postter
	Delete "$INSTDIR\UTILS\ADPOST\ad1.txt"
	Delete "$INSTDIR\UTILS\ADPOST\ad.exe"
	Delete "$INSTDIR\UTILS\ADPOST\ad2.txt"
	Delete "$INSTDIR\UTILS\ADPOST\file_id.diz"
	Delete "$INSTDIR\UTILS\ADPOST\msg-id.dat"
	Delete "$INSTDIR\UTILS\ADPOST\ad.ini"

	; Clean up Ansi2Gif / Ansi2 ___
	Delete "$INSTDIR\UTILS\ANSI2GIF\pvw32con.exe"
	Delete "$INSTDIR\UTILS\ANSI2GIF\pngans.exe"
	Delete "$INSTDIR\UTILS\ANSI2GIF\convert.bat"
	Delete "$INSTDIR\UTILS\ANSI2GIF\TODO.ANS"
	Delete "$INSTDIR\UTILS\ANSI2GIF\FAQ.ANS"
	Delete "$INSTDIR\UTILS\ANSI2GIF\todo.bmp"
	Delete "$INSTDIR\UTILS\ANSI2GIF\faq.bmp"

	; Clean up GameSrv
	Delete "$INSTDIR\UTILS\GAMESRV\GameSrv.exe"
	Delete "$INSTDIR\UTILS\GAMESRV\NF.BAT"
	Delete "$INSTDIR\UTILS\GAMESRV\SETUP.INI"
	Delete "$INSTDIR\UTILS\GAMESRV\Shortcut to GameSrv.exe.lnk"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\gamesrv-1.png"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\gamesrv-2.png"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\gamesrv-3.png"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\gamesrv-4.png"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\gamesrv-5.png"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\gamesrv-6.png"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\gamesrv-7.png"
	Delete "$INSTDIR\UTILS\GAMESRV\Doc\GameSrv.html"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\dosxtrn.exe"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\DOSXTRN.PIF"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\mSyncFos.cfg"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\mSyncFos.dof"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\mSyncFos.dpr"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\mSyncFos.exe"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\sbbsexec.dll"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\sbbsexec.vxd"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\DOSXTRN.EXE"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\FILE_ID.DIZ"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\gpl.txt"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\READ.ME"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\sbbsexec.dll"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\syncfos.exe"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\syncfos.foscfg"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\SYNCFOS.PAS"
	Delete "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\SYNCFOS.TXT"

	; Clean up Multi-Server
	Delete "$INSTDIR\UTILS\MSERV\alias.cfg"
	Delete "$INSTDIR\UTILS\MSERV\file_id.diz"
	Delete "$INSTDIR\UTILS\MSERV\in.bat"
	Delete "$INSTDIR\UTILS\MSERV\in.cmd"
	Delete "$INSTDIR\UTILS\MSERV\mserve2.exe"
	Delete "$INSTDIR\UTILS\MSERV\mserve32.exe"
	Delete "$INSTDIR\UTILS\MSERV\restrict.cfg"
	Delete "$INSTDIR\UTILS\MSERV\route.cfg"
	Delete "$INSTDIR\UTILS\MSERV\servers.cfg"
	Delete "$INSTDIR\UTILS\MSERV\servers.doc"
	Delete "$INSTDIR\UTILS\MSERV\howto.tut"

	; Clean up mtype
	Delete "$INSTDIR\UTILS\MTYPE\MTYPE.EXE"
	Delete "$INSTDIR\UTILS\MTYPE\MTYPE.DOC"
	Delete "$INSTDIR\UTILS\MTYPE\FILE_ID.DIZ"
	Delete "$INSTDIR\UTILS\MTYPE\T.BAT"

	; Clean up Pipe Draw
	Delete "$INSTDIR\UTILS\PIPEDRAW.DOC"
	Delete "$INSTDIR\UTILS\PIPEDRAW.IN~"
	Delete "$INSTDIR\UTILS\DEFAULT.MCI"
	Delete "$INSTDIR\UTILS\BBSLIST.MCI"
	Delete "$INSTDIR\UTILS\USERLIST.MCI"
	Delete "$INSTDIR\UTILS\LASTCALL.MCI"
	Delete "$INSTDIR\UTILS\NODELIST.MCI"
	Delete "$INSTDIR\UTILS\FILE_ID.DIZ"
	Delete "$INSTDIR\UTILS\PIPEDRAW.EXE"
	Delete "$INSTDIR\UTILS\P.BAT"
	Delete "$INSTDIR\UTILS\PIPEDRAW.INI"

	; Remove remaining directories
	RMDir "$SMPROGRAMS\Renegade BBS"
	RMDir "$INSTDIR\UTILS\MTYPE\"
	RMDir "$INSTDIR\UTILS\MSERV\"
	RMDir "$INSTDIR\UTILS\GAMESRV\mSyncFos\FOS_202\"
	RMDir "$INSTDIR\UTILS\GAMESRV\mSyncFos\"
	RMDir "$INSTDIR\UTILS\GAMESRV\Doc\"
	RMDir "$INSTDIR\UTILS\GAMESRV\"
	RMDir "$INSTDIR\UTILS\ANSI2GIF\"
	RMDir "$INSTDIR\UTILS\ADPOST\"
	RMDir "$INSTDIR\UTILS\ACTION\"
	RMDir "$INSTDIR\UTILS\"
	RMDir "$INSTDIR\PROT\"
	RMDir "$INSTDIR\MSGS\"
	RMDir "$INSTDIR\MISC\"
	RMDir "$INSTDIR\MENU\"
	RMDir "$INSTDIR\DOCS\"
	RMDir "$INSTDIR\DATA\"
	RMDir "$INSTDIR\ARCS\"
	RMDir "$INSTDIR\"

SectionEnd

; eof